﻿var Buttons = function () {
    this.errorMessages = {};
}

Buttons.prototype.LockButton = function (e) {
    var allIsOk = true;
    var clickedButton = e.currentTarget;
  
    if (clickedButton.type == "submit") {
        var formElement = clickedButton.closest("form"),
            inputs = formElement.getElementsByTagName("INPUT"),
            textareas = formElement.getElementsByTagName("TEXTAREA"),
            fields = Array.prototype.slice.call(inputs).concat(Array.prototype.slice.call(textareas));
    
        for (var i = 0; i < fields.length; i++) {
            if (!fields[i].validity.valid) {
                allIsOk = false;

                if (!this.errorMessages[i]) {
                    this.errorMessages[i] = this.CreateErrorMessage(fields[i]);
                    fields[i].parentNode.appendChild(this.errorMessages[i]);
                }
            } else if (fields[i].validity.valid && this.errorMessages[i]) {
                this.errorMessages[i].parentNode.removeChild(this.errorMessages[i]);
                delete this.errorMessages[i];
            }
        }
    } 

    //Secure that there is time for a form time to submit
    if (!allIsOk) {
        return;
    }

    if (allIsOk) {
        setTimeout(function () {
            var clickedButtonText = clickedButton.innerHTML;
            var clickedButtonWidth = clickedButton.clientWidth;
            clickedButton.classList.add("disabled");
            clickedButton.disabled = true;
            clickedButton.innerHTML = "<i class=\"fas fa-circle-notch fa-spin\"></i>";
            clickedButton.style.width = clickedButtonWidth + "px";

            var event = new CustomEvent('buttonIsLocked');
            document.dispatchEvent(event);
            clickedButton.dispatchEvent(event);
        }, 50);
    }
}

Buttons.prototype.CreateErrorMessage = function (input) {
    var message = document.createElement("div");
    message.classList.add("field-error");
    message.textContent = input.type === "checkbox" ? "Field is required" : "Field is invalid";

    return message;
};

var Buttons = new Buttons();